/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.securechannel;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSource;
import org.acegisecurity.securechannel.ChannelDecisionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ChannelProcessingFilter
implements InitializingBean,
Filter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$securechannel$ChannelProcessingFilter == null ? (class$org$acegisecurity$securechannel$ChannelProcessingFilter = ChannelProcessingFilter.class$("org.acegisecurity.securechannel.ChannelProcessingFilter")) : class$org$acegisecurity$securechannel$ChannelProcessingFilter));
    private ChannelDecisionManager channelDecisionManager;
    private FilterInvocationDefinitionSource filterInvocationDefinitionSource;
    static /* synthetic */ Class class$org$acegisecurity$securechannel$ChannelProcessingFilter;

    public void setChannelDecisionManager(ChannelDecisionManager channelDecisionManager) {
        this.channelDecisionManager = channelDecisionManager;
    }

    public ChannelDecisionManager getChannelDecisionManager() {
        return this.channelDecisionManager;
    }

    public void setFilterInvocationDefinitionSource(FilterInvocationDefinitionSource filterInvocationDefinitionSource) {
        this.filterInvocationDefinitionSource = filterInvocationDefinitionSource;
    }

    public FilterInvocationDefinitionSource getFilterInvocationDefinitionSource() {
        return this.filterInvocationDefinitionSource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.filterInvocationDefinitionSource, (String)"filterInvocationDefinitionSource must be specified");
        Assert.notNull((Object)this.channelDecisionManager, (String)"channelDecisionManager must be specified");
        Iterator iter = this.filterInvocationDefinitionSource.getConfigAttributeDefinitions();
        if (iter == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Could not validate configuration attributes as the FilterInvocationDefinitionSource did not return a ConfigAttributeDefinition Iterator");
            }
            return;
        }
        HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
        while (iter.hasNext()) {
            ConfigAttributeDefinition def = (ConfigAttributeDefinition)iter.next();
            Iterator attributes = def.getConfigAttributes();
            while (attributes.hasNext()) {
                ConfigAttribute attr = (ConfigAttribute)attributes.next();
                if (this.channelDecisionManager.supports(attr)) continue;
                set.add(attr);
            }
        }
        if (set.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Validated configuration attributes");
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration attributes: " + ((Object)set).toString());
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("HttpServletRequest required");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("HttpServletResponse required");
        }
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        ConfigAttributeDefinition attr = this.filterInvocationDefinitionSource.getAttributes(fi);
        if (attr != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request: " + fi.getFullRequestUrl() + "; ConfigAttributes: " + attr.toString()));
            }
            this.channelDecisionManager.decide(fi, attr);
            if (fi.getResponse().isCommitted()) {
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

