/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.anonymous;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.userdetails.memory.UserAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AnonymousProcessingFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$anonymous$AnonymousProcessingFilter == null ? (class$org$acegisecurity$providers$anonymous$AnonymousProcessingFilter = AnonymousProcessingFilter.class$("org.acegisecurity.providers.anonymous.AnonymousProcessingFilter")) : class$org$acegisecurity$providers$anonymous$AnonymousProcessingFilter));
    private String key;
    private UserAttribute userAttribute;
    private boolean removeAfterRequest = true;
    static /* synthetic */ Class class$org$acegisecurity$providers$anonymous$AnonymousProcessingFilter;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setRemoveAfterRequest(boolean removeAfterRequest) {
        this.removeAfterRequest = removeAfterRequest;
    }

    public boolean isRemoveAfterRequest() {
        return this.removeAfterRequest;
    }

    public void setUserAttribute(UserAttribute userAttributeDefinition) {
        this.userAttribute = userAttributeDefinition;
    }

    public UserAttribute getUserAttribute() {
        return this.userAttribute;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userAttribute);
        Assert.hasLength((String)this.key);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean addedToken = false;
        if (this.applyAnonymousForThisRequest(request)) {
            if (SecurityContextHolder.getContext().getAuthentication() == null) {
                SecurityContextHolder.getContext().setAuthentication(this.createAuthentication(request));
                addedToken = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Populated SecurityContextHolder with anonymous token: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("SecurityContextHolder not populated with anonymous token, as it already contained: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
            }
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (addedToken && this.removeAfterRequest && this.createAuthentication(request).equals(SecurityContextHolder.getContext().getAuthentication())) {
                SecurityContextHolder.getContext().setAuthentication(null);
            }
        }
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    protected boolean applyAnonymousForThisRequest(ServletRequest request) {
        return true;
    }

    protected Authentication createAuthentication(ServletRequest request) {
        return new AnonymousAuthenticationToken(this.key, this.userAttribute.getPassword(), this.userAttribute.getAuthorities());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

