/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.concurrent;

import java.util.Date;
import org.springframework.util.Assert;

public class SessionInformation {
    private Date lastRequest;
    private Object principal;
    private String sessionId;
    private boolean expired = false;

    public SessionInformation(Object principal, String sessionId, Date lastRequest) {
        Assert.notNull((Object)principal, (String)"Principal required");
        Assert.hasText((String)sessionId, (String)"SessionId required");
        Assert.notNull((Object)lastRequest, (String)"LastRequest required");
        this.principal = principal;
        this.sessionId = sessionId;
        this.lastRequest = lastRequest;
    }

    private SessionInformation() {
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Date getLastRequest() {
        return this.lastRequest;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void expireNow() {
        this.expired = true;
    }

    public void refreshLastRequest() {
        this.lastRequest = new Date();
    }
}

